package org.codefilarete.stalactite.engine.runtime;

import javax.sql.DataSource;

import org.codefilarete.stalactite.sql.sqlite.SQLiteDialectBuilder;
import org.codefilarete.stalactite.sql.sqlite.test.SQLiteInMemoryDataSource;
import org.junit.jupiter.api.BeforeEach;

/**
 * Same as {@link InsertExecutorAutoGeneratedKeysITTest} but dedicated to Derby because of its implementation of generated keys.
 *
 * @author Guillaume Mary
 */
public class InsertExecutorAutoGeneratedKeysSQLiteTest extends InsertExecutorAutoGeneratedKeysITTest {
	
	@Override
	protected DataSource giveDataSource() {
		return new SQLiteInMemoryDataSource();
	}
	
	@Override
	@BeforeEach
	void createDialect() {
		dialect = SQLiteDialectBuilder.defaultSQLiteDialect();
	}
}
